dofile("scripts/LevelManager.lua");

LManager = LevelManager.create();

LManager:AddNewTable( 1, 4, 300, 265, "assets/images/table/ballroom", "assets/images/food/item_mark3", "R" );
LManager:AddNewTable( 2, 3, 180, 400, "assets/images/table/ballroom", "assets/images/food/item_mark1", "R" );
LManager:AddNewTable( 3, 3, 400, 400, "assets/images/table/ballroom", "assets/images/food/item_mark2", "R" );

useFloAsServer = 0;
useWineTable = 0;
numMoodBoosts = 1;
numServers = 1;
maxCoupleHappiness = 200;

-- Group 1
guest = LManager.GenGuest(female04);
guest.matchType = male01;
LManager:AddGuest(guest);

guest = LManager.GenGuest(uncle);
guest.matchType = female04;
guest.percentRequestCoffee = 30;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male01);
guest.matchType = female04;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male01);
guest.matchType = table2;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female04);
guest.matchType = table1;
LManager:AddGuest(guest);


LManager:SetSeatingGroup(1, 5, 3000);

--Group 2

guest = LManager.GenGuest(female03);
guest.matchType = NOT_GUEST + female01;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female01);
guest.matchType = NOT_GUEST + female04;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(6, 7, 22000);


-- Group 3


guest = LManager.GenGuest(female01);
guest.matchType = NOT_GUEST + male01;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male01);
guest.matchType = female03;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(8, 9, 40000);


-- Group 4


guest = LManager.GenGuest(male04);
guest.matchType = table1;
LManager:AddGuest(guest);

guest = LManager.GenGuest(aunt);
guest.matchType = male04;
guest.percentRequestTissue = 30;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(10, 11, 68000);


-- Group 5

guest = LManager.GenGuest(male01);
guest.matchType = table3;
LManager:AddGuest(guest);


guest = LManager.GenGuest(uncle);
guest.matchType = table1;
guest.percentRequestCoffee = 30;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(12, 13, 85000);


-- Group 6


guest = LManager.GenGuest(female03);
guest.matchType = male04;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male04);
guest.matchType = table2;
LManager:AddGuest(guest);

guest = LManager.GenGuest(uncle);
guest.matchType = female01;
guest.percentRequestCoffee = 30;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female01);
guest.matchType = table3;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(14, 17, 115000);

--Group 6

guest = LManager.GenGuest(male01);
guest.matchType = NOT_GUEST + uncle;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female04);
guest.matchType = female03;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(18, 19, 135000);


LManager:AdjustGuestTolerance(130);

LManager:SetLevelSetting ("speakerDelay", 120000); 
LManager:SetLevelSetting ("speakerChance", 25);

LManager:SetLevelSetting ("bridesmaidsDelay", 80000); 
LManager:SetLevelSetting ("bridesmaidsChance", 100);




-- Set up the Level Settings
LManager:SetLevelNumber(2,5);
LManager:SetLevelScores(7000, 10500);
LManager:SetLevelTime(300000);

LManager:SetMusic("assets/audio/music/Big Band 4.ogg","assets/audio/music/new_dance_2.ogg","assets/audio/music/new_dance_3.ogg");
LManager:SetBackgroundImage("assets/images/bg_ballroom");
LManager:SetChairImage("assets/images/table/chair02");

-- Generate Game Object
gameObject = LManager:GenerateGameObject();

-- Generate Level Settings
levelSetting = LManager:GenerateLevelSettings();

-- Generate Level Dialog
dofile( "scripts/LevelDialogGenerator.lua" );

